package com.richard_gauthier.JaugeVerticale
{
	import com.sti2d.TexteEnBitmap.TexteEnBitmap;
	import flash.display.Bitmap;
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	import flash.text.TextFormatAlign;
	
	/**
	 * ...
	 * @author rg
	 */
	public class JaugeVerticale extends Sprite
	{
		[Embed(source="bar1.png")]
		private var bar1C:Class;
		private var bar1:Bitmap = new bar1C;
		
		[Embed(source="pointe1.png")]
		private var pointe1C:Class;
		private var pointe:Bitmap = new pointe1C;
		
		private var bar1S:Sprite = new Sprite();
		//private var bar2S:Sprite = new Sprite();
		
		private var leTexte:TextField = new TextField();
		public var couleur:uint = 0x000000;
		
		private var miniG:Number = 0;
		private var maxiG:Number = 100;
		
		private var transEnbitmap:TexteEnBitmap = new TexteEnBitmap();
		private var monBitmap:Bitmap;
		
		public function JaugeVerticale(leTitre:String = "Le Titre", unite:String = "Unité", mini:Number = 0, maxi:Number = 100)
		{
			if (mini < maxi)
			{
				maxiG = maxi;
				miniG = mini;
			}
			
			 //bar1.x = bar1.height;
			 //bar1.y = bar1.width;
			 //bar1.rotation = -90;
			 
			 bar1S.addChild(bar1);
			//bar1S.addEventListener(MouseEvent.MOUSE_MOVE, mouseMOUVE);
			addChild(bar1S);
			//addChild(bar2S);
			
			pointe.y = 6;
			bar1S.addChild(pointe);
			
			var ecart:Number = (maxiG - miniG) / 10;
			var ecartX:Number = (529 - 88) / 10;
			var posiX:Number = 88;
			
			for (var i:int = 0; i < 11; i++)
			{
				
				label("" + (miniG + ecart * i), posiX + ecartX * i, 26, 4 , "bar1S" );
				
			}
			
			bar1S.y = bar1S.width;
			bar1S.rotation = -90;
			
			//Placer l'unité
			label(unite, bar1S.width / 2, bar1S.height - 36, 5 );
			//Placer le titre
			label(leTitre, 0 , bar1S.height / 2, 0, "", -90);
			
			var formatTexte:TextFormat = new TextFormat();
			formatTexte.font = "tahoma";
			formatTexte.size = 18;
			//formatTexte.bold = true;
			//formatTexte.color = couleur;
			formatTexte.align = TextFormatAlign.CENTER;
			
			leTexte.width = 10;
			leTexte.height = 20;
			leTexte.autoSize = TextFieldAutoSize.CENTER;
			leTexte.x = bar1S.width / 2 - leTexte.width / 2;
			leTexte.y = bar1S.height - 66;
			leTexte.defaultTextFormat = formatTexte;
			//leTexte.text =  "1000";
			addChild(leTexte);
			setValue(miniG);
		}
		
		public function setValue(value:Number):void
		{
			leTexte.text = "" + value;
			if (value < miniG)
				pointe.x = 77;
			else if (value > maxiG)
				pointe.x = 519;
			else
			{
				if(miniG >= 0) pointe.x = 77 + (519 - 77) / (maxiG - miniG) * value;
				else if(miniG < 0 ) pointe.x = 77 + (519 - 77) / (maxiG - miniG) * (value - miniG);
			
			}
		
		}
		/*
		private function mouseMOUVE(e:MouseEvent):void
		{
			bar2S.graphics.clear();
			bar2S.graphics.lineStyle(1);
			bar2S.graphics.moveTo(mouseX, mouseY);
			bar2S.graphics.lineTo(mouseX, mouseY + 100);
			trace(bar1S.mouseX, "  ", bar1S.mouseY);
			setValue(mouseY - 100);
		}
		*/
		
		private function label(texte:String, posiX:Number, posiY:Number, NbCaracteres:int = -1 , leSprite : String = "", angle : int = 0 ):void
		{
			if (NbCaracteres > 0)
				if (texte.length > NbCaracteres)
					texte = texte.substr(0, NbCaracteres);
			
			monBitmap = new Bitmap(transEnbitmap.transformerTexteEnBitmap(texte));
			monBitmap.x = posiX - monBitmap.width / 2;
			//528
			monBitmap.y = posiY;
			monBitmap.rotation = angle;
			monBitmap.cacheAsBitmap = true;
			
			if( leSprite == "")
			addChild(monBitmap);
			else
			this[leSprite].addChild(monBitmap);
		
			//leTexteMesure.addEventListener(MouseEvent.CLICK,mouseClick)
		
		}
	
	}

}